[COMMENT]
/*
+--------------------------------------------------------------------------
|   Invision Board v1.2
|   ========================================
|   > Mod_Installer 
|   > Module written by Peter(Pit)
|        > Peter member at ibforen.de, ibplanet.de, Pit member at ibplanet.com
|        > email: Peter@ibforen.de
|
|   > Mod_Installer Version Number: 1.00 (2003-07-17)
|   > <c> 2003 by Peter
|
|   > This is the CodeChange.php for Mod Resize Images by Peter
+--------------------------------------------------------------------------
*/
[COMMENT_END]

[INTERFACE]
'title' => 'Resize Images',
'sub_title' => 'Resizes images and signatures to fit to browser window or to a maximum width',
'category' => 'Major Mod',
'compatible' => 'Invision Power Board  1.2',
'version' => '2.4',
'author' => 'Peter',
'email' => 'Peter@ibforen.de',
'mod_token' => 'mod_resize_images',
[INTERFACE_END]

[HISTORY]
Version 2.4
[LIST]
    [*]Sigs could be limited in width, too
    [*]If Thumbnails are activated, downsized thumbnails are created for attached images
    [*]Thumbnail-Tag added [tmb]..[/tmb]
[/LIST]
[HISTORY_END]

[SQL]

[SQL_END]

[CODE]

[MOD_TOKEN]
mod_resize_images

[FNAME]
index.php

[STEP]
[SEARCH]
require ROOT_PATH."conf_global.php";

[INSERT] 
//-- mod_resize_images begin 
    if (file_exists(ROOT_PATH."sources/mods/resize_images/mod_resize_images_func.php")) {
        require ROOT_PATH."sources/mods/resize_images/mod_resize_images_func.php";
        $mod_rsi->set_quality($INFO['do_scale_images_quality']);
        $mod_rsi->set_jpeg($INFO['do_scale_images_jpeg']);
    } else {
        die("Could not call required function from file 'sources/mods/resize_images/mod_resize_images_func.php'<br>Does it exist?");
    }
//-- mod_resize_images end

[MODE]
insert_below

[FNAME_END]

[MOD_TOKEN]
mod_resize_images

[FNAME]
admin.php

[STEP]
[SEARCH]
require ROOT_PATH."conf_global.php";

[INSERT] 
//-- mod_resize_images begin 
    if (file_exists(ROOT_PATH."sources/mods/resize_images/mod_resize_images_func.php")) {
        require ROOT_PATH."sources/mods/resize_images/mod_resize_images_func.php";
        $mod_rsi->set_quality($INFO['do_scale_images_quality']);
        $mod_rsi->set_jpeg($INFO['do_scale_images_jpeg']);
    } else {
        die("Could not call required function from file 'sources/mods/resize_images/mod_resize_images_func.php'<br>Does it exist?");
    }
//-- mod_resize_images end

[MODE]
insert_below

[FNAME_END]

[MOD_TOKEN]
mod_resize_images

[FNAME]
sources/functions.php

[STEP]
[SEARCH]
        print $ibforums->skin['template'];
        
        exit;
    }

[INSERT] 
//-- mod_resize_images begin 
        global $mod_rsi;
        if ($ibforums->vars['board_offline'] != 1)
            $mod_rsi->get_resize_methods();
//-- mod_resize_images end

[MODE]
insert_above

[FNAME_END]

[MOD_TOKEN]
mod_resize_images

[FNAME]
sources/Post.php

[STEP]
[SEARCH]
		if (! @move_uploaded_file( $HTTP_POST_FILES['FILE_UPLOAD']['tmp_name'], $ibforums->vars['upload_dir']."/".$real_file_name) )
		{
			$this->obj['post_errors'] = 'upload_failed';
			return $attach_data;
		}
		else
		{
			@chmod( $ibforums->vars['upload_dir']."/".$real_file_name, 0777 );

[INSERT] 
//-- mod_resize_images begin
        if ($ibforums->vars['do_scale_images_edit']) {
            $file = $ibforums->vars['upload_dir']."/".$real_file_name;
            $size = @getimagesize($file, $info);
            if ($size[0] > 0) {
                if ( $ibforums->vars['siu_thumb'] AND $ibforums->vars['siu_width'] AND $ibforums->vars['siu_height'] ) {
                    $dest_file = preg_replace("`(.*)\.(.*)`", "\\1_thumb.\\2", $file);
                    if (copy($file, $dest_file)) {
                        $scale = $ibforums->vars['siu_width']/((float) $size[0]);
                        $scale1 = $ibforums->vars['siu_height']/((float) $size[1]);
                        if ($scale1 < $scale) $scale = $scale1;
                        if ($scale < 1) {
                            global $mod_rsi;
                            $temp = $mod_rsi->scale_image($dest_file, $scale);
                        }
                    }
                } 
                else {
                    $DB->query("SELECT set_id FROM ibf_skins WHERE default_set=1");
                    if ($r = $DB->fetch_row()) {
                        $skin_id = $r['set_id'];
                    } else {
                        $skin_id = $ibforums->skin_id;
                    }
                    if (file_exists(ROOT_PATH."Skin/s".$skin_id."/mod_resize_images_skin.php")) {
                        if (class_exists("mod_resize_images_skin")) {
                                  $mod_rsi_skin = new mod_resize_images_skin;
                        } else {
                                  $mod_rsi_skin = $std->load_template('mod_resize_images_skin');
                        }
                    } else {
                        die("Could not fetch the template from skin directory. Template File 'mod_resize_images_skin.php', Skin ID {$ibforums->skin_rid}"); 
                    }
                    $maxwidth = (float) preg_replace("/<!--.+?-->/ie","",$mod_rsi_skin->get_max_image_width());
                    $scale = $maxwidth/((float) $size[0]);
                    if ($scale < 1) {
                        global $mod_rsi;
                        if ($temp = $mod_rsi->scale_image($file, $scale)) {
                            $real_file_name = basename($temp);
                            $FILE_NAME = str_replace(".gif", ".jpg", strtolower($FILE_NAME));
                        }
                    }
                }
            }
        }
//-- mod_resize_images end

[MODE]
insert_below


[STEP]
[SEARCH]
		$this->output .= $this->html->TopicSummary_top();

[INSERT] 
//-- mod_resize_images begin
        $this->output .= "<!-- TopicSummaryTop -->";
//-- mod_resize_images end

[MODE]
insert_above

[STEP]
[SEARCH]
        $this->output .= $this->html->TopicSummary_bottom();
    
[INSERT] 
//-- mod_resize_images begin
    $this->output .= "<!-- TopicSummaryBottom -->";
//-- mod_resize_images end

[MODE]
insert_below

[FNAME_END]

[MOD_TOKEN]
mod_resize_images

[FNAME]
sources/Topics.php

[STEP]
[SEARCH]
					{
						//----------------------------------------------------
						// Standard size..
						//----------------------------------------------------
						
						$row['attachment'] = $this->html->Show_attachments_img( $row['attach_id'] );
					}

[INSERT] 
//-- mod_resize_images begin 
                    $search = "#<img(.+?)src=[\'\"](.+?)[\'\"](.+?)alt=[\'\"](.+?)[\'\"](.*?)>#i";
                    preg_match ($search, $row['attachment'], $images);

                    $url = $images[2];
                    $size = @getimagesize($url, $info);
                    if ($size[0] > 0) {
                        $replace = "<!--aimg--><a href='$url' target='_blank'>".
                                         "<img{$images[1]}src='$url'{$images[3]}alt='--Resize_Images_Alt_Text--' width='$size[0]' height='$size[1]'{$images[5]}></a>".
                                         "<!--Resize_Images_Hint_Text--><!--/aimg-->";
                        $row['attachment'] = preg_replace($search, $replace, $row['attachment']);
                    }
                    if ( $ibforums->vars['siu_thumb'] AND $ibforums->vars['siu_width'] AND $ibforums->vars['siu_height'] ) {
                        $thumb_file = preg_replace("`(.*)\.(.*)`", "\\1_thumb.\\2",$ibforums->vars['upload_url']."/".$row['attach_id']);
                        $thumb_realfile = preg_replace("`(.*)\.(.*)`", "\\1_thumb.\\2",$ibforums->vars['upload_dir']."/".$row['attach_id']);
                        if (file_exists($thumb_realfile) ) {
                            $search = "#<img(.+?)src=[\'\"](.+?)[\'\"]#i";
                            $replace = "<img\\1src='".$thumb_file."'";
                            $row['attachment'] = preg_replace($search, $replace, $row['attachment']);
                        }
                    }
//-- mod_resize_images end

[MODE]
insert_below

[STEP]
[SEARCH]
			//--------------------------------------------------------------
			// A bit hackish - but there are lots of <br> => <br /> changes to make
			//--------------------------------------------------------------
			
			$row['post']      = str_replace( "<br>", "<br />", $row['post'] );
			$row['signature'] = str_replace( "<br>", "<br />", $row['signature'] );
			

[INSERT] 
//-- mod_resize_images begin
            $row['signature'] = "<!--Signature-->".$row['signature']."<!--E-Signature-->";
//-- mod_resize_images end

[MODE]
insert_below

[FNAME_END]

[MOD_TOKEN]
mod_resize_images

[FNAME]
sources/Admin/ad_settings.php

[STEP]
[SEARCH]
			case 'dopost':

[INSERT] 
//-- mod_resize_images begin
                global $mod_rsi;
                $mod_rsi->save_config();
       
                if (isset($IN['poll_tags'] ))
//-- mod_resize_images end

[MODE]
insert_below

[STEP]
[SEARCH]
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>No. characters to word wrap on?</b><br>Prevents long unbroken words which distort tables. 80 - 100 is recommended" ,
										  $SKIN->form_input( "post_wordwrap", $INFO['post_wordwrap'] )
								 )      );

[INSERT] 
//-- mod_resize_images begin 
        global $mod_rsi;
        $mod_rsi->ad_settings();
//-- mod_resize_images end

[MODE]
insert_below

[FNAME_END]

[MOD_TOKEN]
mod_resize_images

[FNAME]
sources/lib/post_parser.php

[STEP]
[SEARCH]
class post_parser {

[INSERT] 
//-- mod_resize_images begin 
        var $mod_resize_images_start_time = 0;
        var $mod_resize_images_timeout = 30;
//-- mod_resize_images end

[MODE]
insert_below

[STEP]
[SEARCH]
	function post_parser($load=0)
	{
		global $ibforums, $DB;

[INSERT] 
//-- mod_resize_images begin
        $current_version = (int)str_replace('.', '', phpversion());
        if ($current_version < 420) {
                $this->mod_resize_images_timeout = ini_get ('max_execution_time');
        } else {
                $a = ini_get_all();
                $this->mod_resize_images_timeout = $a['max_execution_time']['global_value'];
                unset ($a);
        }
//-- mod_resize_images end

[MODE]
insert_below

[STEP]
[SEARCH]
	function parse_poll_tags($txt)
	{

[INSERT] 
//-- mod_resize_images begin 
        $this->mod_resize_images_start_time = time();
        $txt = preg_replace( "#\[tmb\](.+?)\[/tmb\]#ie"  , "\$this->regex_check_tmb('\\1')", $txt );
//-- mod_resize_images end  

[MODE]
insert_below


[STEP]
[SEARCH]
			if ($ibforums->vars['allow_images'])
			{

[INSERT] 
//-- mod_resize_images begin 
                $this->mod_resize_images_start_time = time();
                $txt = preg_replace( "#\[tmb\](.+?)\[/tmb\]#ie"  , "\$this->regex_check_tmb('\\1')", $txt );
//-- mod_resize_images end

[MODE]
insert_below


[STEP]
[SEARCH]
            $txt = preg_replace( "#<!--sql-->(.+?)<!--sql1-->(.+?)<!--sql2-->(.+?)<!--sql3-->#eis"    , "\$this->unconvert_sql(\"\\2\")", $txt);
            $txt = preg_replace( "#<!--html-->(.+?)<!--html1-->(.+?)<!--html2-->(.+?)<!--html3-->#e", "\$this->unconvert_htm(\"\\2\")", $txt);

[INSERT] 
//-- mod_resize_images begin
            // Idea by Hotohori
            $txt = preg_replace( "#<!--aimg-->(.+?)k'>(.+?)</a>(.+?)<!--/aimg-->#", "\\2" , $txt );

            $txt = preg_replace( "#<!--mod_tmb-->(.+?)href='(.+?)'(.+?)<!--emod_tmb-->#s", "[tmb]\\2[/tmb]" , $txt );
//-- mod_resize_images end

[MODE]
insert_above


[STEP]
[SEARCH]
    /**************************************************/
    // regex_check_image: Checks, and builds the <img>
    // html.
    /**************************************************/
    
    function regex_check_image($url="") {

[INSERT] 
//-- mod_resize_images begin 
    function regex_check_tmb($url="") {
        global $ibforums, $std;
        
        if (!$url) return;
        
        $url = trim($url);
        
        $default = "[tmb]".$url."[/tmb]";
        
        ++$this->image_count;
        if ($ibforums->vars['max_images']) {
            if ($this->image_count > $ibforums->vars['max_images']) {
                $this->error = 'too_many_img';
                return $default;
            }
        }
        if ($ibforums->vars['allow_dynamic_img'] != 1) {
            if (preg_match( "/[?&;]/", $url)) {
                $this->error = 'no_dynamic';
                return $default;
            }
            if (preg_match( "/javascript(\:|\s)/i", $url )) {
                $this->error = 'no_dynamic';
                return $default;
            }
        }
        if ($ibforums->vars['img_ext']) {
            $extension = preg_replace( "#^.*\.(\S+)$#", "\\1", $url );
            $extension = strtolower($extension);
            
            if ( (! $extension) OR ( preg_match( "#/#", $extension ) ) ) {
                $this->error = 'invalid_ext';
                return $default;
            }
            $ibforums->vars['img_ext'] = strtolower($ibforums->vars['img_ext']);
            if (!preg_match( "/".preg_quote($extension, '/')."(\||$)/", $ibforums->vars['img_ext'] )) {
                $this->error = 'invalid_ext';
                return $default;
            }
        }
        
        if (!preg_match( "/^(http|https|ftp):\/\//i", $url )) {
            $this->error = 'no_dynamic';
            return $default;
        }
        
        $tmb_url = $url;
        if (preg_match("`{$ibforums->vars["upload_url"]}`i", $tmb_url)) {
            $filename = preg_replace("`{$ibforums->vars["upload_url"]}`i", ROOT_PATH."/uploads", $tmb_url);
            if (file_exists(preg_replace("`(.*)\.(.*)`i","\\1_thumb.\\2", $filename)))
                $tmb_url = preg_replace("`(.*)\.(.*)`i","\\1_thumb.\\2", $tmb_url);
        }
        else {
            $size = @getimagesize(preg_replace("`(.*)\.(.*)`i","\\1_thumb.\\2", $tmb_url), $info);
            if ($size[0] > 0) 
                $tmb_url = preg_replace("`(.*)\.(.*)`i","\\1_thumb.\\2", $tmb_url);
        }
        $url = str_replace( " ", "%20", $url );
        $tmb_url = str_replace( " ", "%20", $tmb_url );

        $width = $ibforums->vars["siu_width"];
        $height = $ibforums->vars["siu_height"];

        $size = @getimagesize($url, $info);
        if ($size[0] > 0) {
            $scale = $ibforums->vars['siu_width']/(float) $size[0];
            $scale1 = $ibforums->vars['siu_height']/(float) $size[1];
            if ($scale1 < $scale) $scale = $scale1;
            if ($scale < 1) {
                $width = $size[0]*$scale;
                $height = $size[1]*$scale;
            }
        }
        $ibforums->lang  = $std->load_words($ibforums->lang, 'mod_resize_images_lang', $ibforums->lang_id);

        return "<!--mod_tmb--><a href='$url' target='_blank' title='{$ibforums->lang['Thumbnail_Alt_Text']}'><img src='$tmb_url' width='$width' height='$height' border='0' alt='{$ibforums->lang['Thumbnail_Alt_Text']}' name='{$ibforums->lang['Thumbnail_Alt_Text']}' class='attach' /></a><br /><font size='1'><b>{$ibforums->lang['Thumbnail_Hint_Text']}</b></font><br /><!--emod_tmb-->";
    }
//-- mod_resize_images end
[MODE]
insert_above

[STEP]
[SEARCH]
		// If we are still here....
		
		$url = str_replace( " ", "%20", $url );

[INSERT] 
//-- mod_resize_images begin 
        if ( ( time() - $this->mod_resize_images_start_time + 2 ) < $this->mod_resize_images_timeout) {
            $size = @getimagesize($url, $info);
        if ($size[0] > 0) {
            if (stristr($url, $ibforums->vars['board_url'])) {
                if ($ibforums->vars['do_scale_images_edit']) {
                    $temp = ROOT_PATH.str_replace(strtolower($ibforums->vars['board_url'])."/", "", strtolower($url));
                    global $DB, $std;
                    $DB->query("SELECT set_id FROM ibf_skins WHERE default_set=1");
                    if ($r = $DB->fetch_row()) {
                        $skin_id = $r['set_id'];
                    } else {
                        $skin_id = $ibforums->skin_id;
                    }
                    if (file_exists(ROOT_PATH."Skin/s".$skin_id."/mod_resize_images_skin.php")) {
                        if (class_exists("mod_resize_images_skin")) {
                   	   		$mod_rsi_skin = new mod_resize_images_skin;
                        } else {
                   	   		$mod_rsi_skin = $std->load_template('mod_resize_images_skin');
                        }
                    } else {
                        die("Could not fetch the template from skin directory. Template File 'mod_resize_images_skin.php', Skin ID {$skin_rid}");
                    }
                    if ($this->in_sig) {
                        $maxwidth = (float) preg_replace("/<!--.+?-->/ie","",$mod_rsi_skin->get_max_image_height_signature());
                        $scale = $maxwidth/((float) $size[1]);
                    } else {
                        $maxwidth = (float) preg_replace("/<!--.+?-->/ie","",$mod_rsi_skin->get_max_image_width());
                        $scale = $maxwidth/((float) $size[0]);
                    }
                    if ($scale < 1) {
                        global $mod_rsi;
                        if ($temp = $mod_rsi->scale_image($temp, $scale)) {
                            $url = $ibforums->vars['board_url']."/".str_replace(strtolower(ROOT_PATH), "", strtolower($temp));
                            $size = @getimagesize($url, $info);
                        }
                    }
                }
            }
            return   "<!--aimg--><a href='$url' target='_blank'>".
                        "<img src='$url' alt='--Resize_Images_Alt_Text--' width='$size[0]' height='$size[1]'  class='attach' /></a>".
                        "<!--Resize_Images_Hint_Text--><!--/aimg-->";
            } else {
                return "<img src='$url' border='0' alt='user posted image' class='attach' />";
            }
        } else {
//-- mod_resize_images end 

[MODE]
insert_below


[STEP]
[SEARCH]
		return "<img src='$url' border='0' alt='user posted image' />";
 

[INSERT] 
//-- mod_resize_images begin 
        } 
//-- mod_resize_images end

[MODE]
insert_below


[FNAME_END]


[MOD_TOKEN]
mod_resize_images

[FNAME]
sources/lib/post_edit_post.php

[STEP]
[SEARCH]
                    @unlink($ibforums->vars['upload_dir']."/".$this->orig_post['attach_id']);
[INSERT] 
//-- mod_resize_images begin 
                    @unlink($ibforums->vars['upload_dir']."/".preg_replace("`(.*)\.(.*)`", "\\1_thumb.\\2", $this->orig_post['attach_id']));
//-- mod_resize_images end
[MODE]
insert_below

[STEP]
[SEARCH]
			$class->output .= $class->html->preview( $this->post['post'] );
[INSERT] 
//-- mod_resize_images begin
            $class->output .= "<!-- Post Preview-->";
//-- mod_resize_images end

[MODE]
insert_above

[STEP]
[SEARCH]
			$class->output .= $class->html->preview( $this->post['post'] );
[INSERT] 
//-- mod_resize_images begin
            $class->output .= "<!-- End Post Preview-->";
//-- mod_resize_images end

[MODE]
insert_below

[STEP]
[SEARCH]
        $post_box    = $class->html_post_body( $raw_post );

[INSERT] 
//-- mod_resize_images begin
        $txt = $post_box;
        $new_button = "\n<input type='button' accesskey='2' value=' TMB '     onclick='tag_tmb()'     class='codebuttons' name='TMB' />";
        preg_match("`(<input.*?hstat.*?\'list\'.*?/>)`ie", $txt, $matches);
        $post_box = str_replace( $matches[1], $matches[1].$new_button, $txt );
//-- mod_resize_images end
[MODE]
insert_below

[FNAME_END]



[MOD_TOKEN]
mod_resize_images

[FNAME]
sources/lib/post_new_post.php

[STEP]
[SEARCH]
			$class->output .= $class->html->preview( $this->post['post'] );
[INSERT] 
//-- mod_resize_images begin
            $class->output .= "<!-- Post Preview-->";
//-- mod_resize_images end

[MODE]
insert_above

[STEP]
[SEARCH]
			$class->output .= $class->html->preview( $this->post['post'] );
[INSERT] 
//-- mod_resize_images begin
            $class->output .= "<!-- End Post Preview-->";
//-- mod_resize_images end

[MODE]
insert_below

[STEP]
[SEARCH]
        $post_box    = $class->html_post_body( $raw_post );

[INSERT] 
//-- mod_resize_images begin
        $txt = $post_box;
        $new_button = "\n<input type='button' accesskey='2' value=' TMB '     onclick='tag_tmb()'     class='codebuttons' name='TMB' />";
        preg_match("`(<input.*?hstat.*?\'list\'.*?/>)`ie", $txt, $matches);
        $post_box = str_replace( $matches[1], $matches[1].$new_button, $txt );
//-- mod_resize_images end
[MODE]
insert_below

[FNAME_END]

[MOD_TOKEN]
mod_resize_images

[FNAME]
sources/lib/post_poll.php

[STEP]
[SEARCH]
			$class->output .= $class->html->preview( $this->post['post'] );
[INSERT] 
//-- mod_resize_images begin
            $class->output .= "<!-- Post Preview-->";
//-- mod_resize_images end

[MODE]
insert_above

[STEP]
[SEARCH]
			$class->output .= $class->html->preview( $this->post['post'] );
[INSERT] 
//-- mod_resize_images begin
            $class->output .= "<!-- End Post Preview-->";
//-- mod_resize_images end

[MODE]
insert_below

[STEP]
[SEARCH]
        $post_box    = $class->html_post_body( $raw_post );

[INSERT] 
//-- mod_resize_images begin
        $txt = $post_box;
        $new_button = "\n<input type='button' accesskey='2' value=' TMB '     onclick='tag_tmb()'     class='codebuttons' name='TMB' />";
        preg_match("`(<input.*?hstat.*?\'list\'.*?/>)`ie", $txt, $matches);
        $post_box = str_replace( $matches[1], $matches[1].$new_button, $txt );
//-- mod_resize_images end
[MODE]
insert_below

[FNAME_END]

[MOD_TOKEN]
mod_resize_images

[FNAME]
sources/lib/post_q_reply_post.php

[STEP]
[SEARCH]
			$class->output .= $class->html->preview( $this->post['post'] );
[INSERT] 
//-- mod_resize_images begin
            $class->output .= "<!-- Post Preview-->";
//-- mod_resize_images end

[MODE]
insert_above

[STEP]
[SEARCH]
			$class->output .= $class->html->preview( $this->post['post'] );
[INSERT] 
//-- mod_resize_images begin
            $class->output .= "<!-- End Post Preview-->";
//-- mod_resize_images end

[MODE]
insert_below

[STEP]
[SEARCH]
        $post_box    = $class->html_post_body( $raw_post );

[INSERT] 
//-- mod_resize_images begin
        $txt = $post_box;
        $new_button = "\n<input type='button' accesskey='2' value=' TMB '     onclick='tag_tmb()'     class='codebuttons' name='TMB' />";
        preg_match("`(<input.*?hstat.*?\'list\'.*?/>)`ie", $txt, $matches);
        $post_box = str_replace( $matches[1], $matches[1].$new_button, $txt );
//-- mod_resize_images end
[MODE]
insert_below

[FNAME_END]

[MOD_TOKEN]
mod_resize_images

[FNAME]
sources/lib/post_reply_post.php

[STEP]
[SEARCH]
			$class->output .= $class->html->preview( $this->post['post'] );
[INSERT] 
//-- mod_resize_images begin
            $class->output .= "<!-- Post Preview-->";
//-- mod_resize_images end

[MODE]
insert_above

[STEP]
[SEARCH]
			$class->output .= $class->html->preview( $this->post['post'] );
[INSERT] 
//-- mod_resize_images begin
            $class->output .= "<!-- End Post Preview-->";
//-- mod_resize_images end

[MODE]
insert_below

[STEP]
[SEARCH]
        $post_box    = $class->html_post_body( $raw_post );

[INSERT] 
//-- mod_resize_images begin
        $txt = $post_box;
        $new_button = "\n<input type='button' accesskey='2' value=' TMB '     onclick='tag_tmb()'     class='codebuttons' name='TMB' />";
        preg_match("`(<input.*?hstat.*?\'list\'.*?/>)`ie", $txt, $matches);
        $post_box = str_replace( $matches[1], $matches[1].$new_button, $txt );
//-- mod_resize_images end
[MODE]
insert_below

[FNAME_END]

[MOD_TOKEN]
mod_resize_images

[FNAME]
html/ibfcode.js

[STEP]
[SEARCH]
function tag_image()

[INSERT] 
//-- mod_resize_images begin
function tag_tmb()
{
    var FoundErrors = '';
    var enterURL   = prompt(text_enter_image, "http://");

    if (!enterURL) {
        FoundErrors += " " + error_no_url;
    }

    if (FoundErrors) {
        alert("Error!"+FoundErrors);
        return;
    }

    doInsert("[TMB]"+enterURL+"[/TMB]", "", false);
}
//-- mod_resize_images end

[MODE]
insert_above

[FNAME_END]

[MOD_TOKEN]
mod_resize_images

[FNAME]
sources/Messenger.php

[STEP]
[SEARCH]
 		$this->output .= $this->post_html->pm_postbox_buttons($old_message);

[INSERT] 
//-- mod_resize_images begin
        $txt = $this->output;
        $new_button = "\n<input type='button' accesskey='2' value=' TMB '     onclick='tag_tmb()'     class='codebuttons' name='TMB' />";
        preg_match("`(<input.*?hstat.*?\'list\'.*?/>)`ie", $txt, $matches);
        $this->output = str_replace( $matches[1], $matches[1].$new_button, $txt );
//-- mod_resize_images end

[MODE]
insert_below

[STEP]
[SEARCH]
 		$this->output .= $this->post_html->postbox_buttons( str_replace( "<br>", "\n", $msg['message']) );

[INSERT] 
//-- mod_resize_images begin
        $txt = $this->output;
        $new_button = "\n<input type='button' accesskey='2' value=' TMB '     onclick='tag_tmb()'     class='codebuttons' name='TMB' />";
        preg_match("`(<input.*?hstat.*?\'list\'.*?/>)`ie", $txt, $matches);
        $this->output = str_replace( $matches[1], $matches[1].$new_button, $txt );
//-- mod_resize_images end

[MODE]
insert_below

[FNAME_END]

[CODE_END]

[COPY]
[LIST][*]sources [arrow] sources
[*]lang/tw [arrow] lang/tw
[*]lang/german [arrow] lang/nn
[*]skin/s1 [arrow] skin/nn (Copy mod_resize_images_skin.php into each skin dir)[/LIST]
[COPY_END]

[CUSTOMIZE]
[STEP]
Navigate  to [b]ACP [arrow] Skins & Templates [arrow] Manage HTML Templates[/b]
and execute in section [b]Template Tools[/b] the famous Run Tool with regards to the concerning skin.

[iframe]doc/images/RunTool.gif width='800' height='400' name='Run Tool'[/iframe]

[STEP]
Now go to [b]ACP [arrow] Skins & Templates [arrow] Manage HTML Templates[/b]
and choose Manage HTML to edit the concerning skin.

[iframe]doc/images/skin_html.gif width='800' height='400' name='Manage Html Template'[/iframe]

There you can find a new section

[iframe]doc/images/skin_section.gif width='800' height='400' name='Skin Section'[/iframe]

Edit the function and customize the return value as you like it

[iframe]doc/images/mod_skin_func.gif width='580' height='200' name='Mod Skin Section'[/iframe]

[STEP]
Now back to [b]ACP [arrow] Skins & Templates [arrow] Manage HTML Templates[/b]
and choose [b]Manage HTML to edit the skin[/b]. Navigate to [b]Topic section[/b]

[iframe]doc/images/topic_render_row.gif width='800' height='400' name='Topic Render Row'[/iframe]

Click on it to expand the view an edit the function [b]Render Row[/b] or [b]Post Entry[/b] depending on your ipb version.

[iframe]doc/images/topic_render_row_cell_id.gif width='580' height='400' name='Render Row Post Cell'[/iframe]

[STEP]
To finish these steps go to [b]ACP [arrow] Board Settings [arrow] Topics, Posts & Polls[/b]
and choose the resizing method in section [b]Resizing Images[/b]

[iframe]doc/images/topic_settings.gif width='760' height='360' name='Topic Section'[/iframe]
[CUSTOMIZE_END]

[COMMENT_MOD]
[b][size=3]Browser Side Methods[/size][/b]

[b]A. Limit To Maximum[/b]
If you choose this option images will be limited to a maximum width only if they exceed this value. 

[b]B. Limit To Maximum (without Javascript)[/b]
This method will have effect only on new or newly edited posts. Only by editing the image's size is stored into the database using the getimagesize method.
Choose this option only if you have installed a new board without any data.

[b]C. Limit To Maximum (additional Javascript)[/b]
I recommend to use this option if you install the mod on a existing board. Older posts will be handled by additional Javascript code. But remember that in this special case all images in your browser's window will be resized. Even if you have a big logo which exceeds the maximum width it will be resized. Seperate the big image into several smaller parts so they will not be resized.

[b]D. Limit To Window[/b]
You can limit images to the width of the post area. You can customize this value in Step 4 described above in Section Customize. It is important the post area cell has an identifier "Post_Cell" and a width value.

If these values doesn't exist all big images will be resized  to 80% of the browser's window width.

You can customize this default value in mod_Resize_Images_func.php Change  

[code]max_width = 0.8;[/code]

[b]E: Show in a limited I-Frame[/b]
Images which exceeds the maximum width will be shown in original size in a frame with scroll bars. Set the frame width as described in Step 2.

[b]F: Add imagesize to older posts?[/b]
This is an Admin tool to add the values width and height to images in older posts. But realize that image urls could be invalid or unreachable. So the script could run out of max_execution_time usually set to 30s.

But you can repeat this operation until all values are added. 


[b][size=3]Server Side Methods[/size][/b]

Since version 2.0 a new feature was added: 
If your server supports the GD library then images can be scaled down persistently. In addition all images in the upload dir can be scaled down

[b]A. Scale images in attachments or scale local images immediately?[/b]
After editing a post attached images or with [IMG]-tag attached images with a local url will be scaled down. With support of the GD library the width and height of images will be reduced to maximum values. So you will save a lot of bandwidth.

But there is one restriction: Since the GIF format is under copyright restriction we cannot write GIF images. They will be converted to JPEG. Animated GIFs will be reduced to the first frame.

In this case your webhoster should provide GIF Read which is supported in PHP >4.3.2. If GIF Read is not supported a built-in routine is to be used which is much slower than the GD routine.

The maximum values depend on those values you have set for the default skinset.

[b]B. Scale all images in upload dir ?[/b]
Similar to the above mentioned Admin Tool Add imagesize to older posts? all images in the upload dir can be scaled down. Set the maximum values for these operation separately.

If you want to scale down to maximum width but not to maximum height set the maximum height very high e.g. 10000.



Feedback is welcomed.
[COMMENT_MOD_END]

[HISTORY_OLD]
[b]2.1.2 [arrow] 2.1.3:[/b]
[List][*]Bugfix for Board Offline
[*]Optimization
Changed files:
[list][*]sources/functions.php, Step 3
[*]sources/Admin/ad_settings.php, Step 6, Part A
[/list]
[/list]

[b]2.1.1 [arrow] 2.1.2[/b]
[List][*]Bugfix "Divide by zero" with PDF-Dokumenten
Changed files:
[list][*]sources/Post.php, Step 4
[*]sources/Topics.php, Step 5
[*]sources/lib/post_parser.php, Step 7, Part F
[*]sources/mods/resize_images/mod_resize_images_func.php (Copy)
[/list]
[/list]
    
[b]2.1 [arrow] 2.1.1[/b]
[List][*]Bugfix for PHP < 4.3.0
Changed files:
sources/mods/resize_images/mod_resize_images_func.php (Copy)
[/list]

[b]2.0 [arrow] 2.1[/b]
[List][*]Quality factor of Jpeg
compression available
[*]Conversion to Jpeg available
Changed files:
[List][*]sources/mods/resize_images/mod_resize_images_func.php (Copy)
[*]index.php, Step 1
[*]admin.php, Step 2 (Attention: Placed some lines below)
[*]sources/Admin/ad_settings.php , Step 6, Part A
[/list]
[/list]
    
[b]1.5 [arrow] 2.0[/b]
[List][*]New feature: Scaling of images on server side persistently to save bandwidth
Changed files:
[List][*]sources/mods/resize_images/mod_resize_images_func.php (Copy)
[*]lang/xx/mod_resize_images_lang.php (Copy)
[*]index.php, Step 1
[*]admin.php, Step 2
[*]sources/functions.php, Step 3
[*]sources/post.php , Step 4
[*]sources/Admin/ad_settings.php , Step 6
[*]sources/lib/post_parser.php, regex_check_image($url=""), Step 7, Parts F
[/list]
[/list]
    
[b]1.4 [arrow] 1.5[/b]
[List][*]Bugfix for some special jpeg's due to a bug of PHP getimagesize()
Changed files:
[List][*]sources/mods/resize_images/mod_resize_images_func.php (Copy)
[*]sources/Topics.php , Step 2
[*]sources/lib/post_parser.php, function ad_settings(), Step 4, Parts F
Always change @getimagesize($url) in @getimagesize($url, $info)
[/list]
[/list]
    
[b]1.3 [arrow] 1.4[/b]
[List][*]Compatible with ipb 1.1.2
Changed files:
[List][*]sources/functions.php , Step 1
[*]sources/Admin/ad_settings.php, function ad_settings(), Step 3, Parts A,B, Step 5 - 9.
[/list]
[/list]    

[b]1.2a [arrow] 1.3[/b]
[List][*]Resizing of images in edit and preview mode
Changed files:
[List][*]sources/mods/resize_images/mod_resize_images_func.php (Copy)
[*]lang/nn/mod_resize_images_lang.php (Copy)
[*]sources/Admin/ad_settings.php, function ad_settings(), Step 3, Partl A, Step 5 - 9.
[/list]
[/list]
    
[b]1.2 [arrow] 1.2a[/b]
[List][*]Handling of images in old posts improved
[*]Links removed for images which are not resized
Changed file:
[list][*]sources/mods/resize_images/mod_resize_images_func.php (Copy)
[*]lang/nn/mod_resize_images_lang.php (Copy)
[*]sources/Admin/ad_settings.php, function ad_settings(), Step 3, Part A
[/list]
[/list]

[b]1.1 [arrow] 1.2[/b]
[List][*]Only Bugfix for resizing signatures, no new features
Changed file:
sources/mods/resize_images/mod_resize_images_func.php (Copy)
[/list]
    

[b]1.0[/b] 
[List][*]Resizung of large images in attachments and signatures
[*]Resizing of large images which are uploaded
[*]Admin options to resize images in
[List][*]posts
[*]signatures[/list]
[*]Admin option to add imagesizes to images in old posts
[*]Localization
[/list]
[HISTORY_OLD_END]

